<?php
/*
	DevSaver Web Framework
	Copyright (c) 2002-2018 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com
*/

namespace StemBase\Modules\Shortcodes\Shortcode;

if (!defined("STPBase")) {
	die("This file can't be accessed directly!");
}

use StemBase\Modules\Shortcodes\Shortcode\ShortcodeBase;

class Device extends ShortcodeBase {

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $name = "device";
	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $version = "1.0";
	
	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $help = "";
	
	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $sample_usage = "[device=\"phone\"]content[/device]\n[device device=\"desktop,tablet\"]content[/device]";

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $sample_attributes = array(
		array(
			"name"	=> "device",
			"hint"	=> "desktop|tablet|phone. Devices where to appear content enclosed in shortcode. for multiple shortcodes add them comma separed."
		)
	);

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Render($data) {
		global $base;

		$vars = $data["vars"];

		if (!$vars["device"] && $vars["attr"]) {
			$vars["device"] = $vars["attr"];
		}

		$devices = explode("," , $vars["device"]);

		if (is_array($devices)) {
			foreach ($devices as $key => $val) {
				$devices[$key] = trim($val);
			}			
		}
		
		if (
			($base->isTablet && in_array("tablet" , $devices)) ||
			($base->isPhone && in_array("phone" , $devices)) ||
			(!($base->isPhone || $base->isTablet) && in_array("desktop" , $devices))
		) {

			return array(
				"content"	=> $vars["content"],
				"before"	=> "",
				"after"		=> "",
			);
		}
	}

	
}